// Generated from C:/Users/Diana/Desktop/matfyz/bakalarka/prog/relationalAlgebra.g4 by ANTLR 4.13.1
package loader;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import topdown.*;
import topdown.operator.*;
import topdown.term.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class provides an empty implementation of {@link relationalAlgebraVisitor},
 * which can be extended to create a visitor which only needs to handle a subset
 * of the available methods.
 *
 * @param <Object> The return type of the visit operation. Use {@link Void} for
 * operations with no return type.
 */
public class relationalAlgebraBaseVisitor<Object> extends AbstractParseTreeVisitor<Object> implements relationalAlgebraVisitor<Object> {
	private Database edb = new Database();
	private Map<String, Operator> idb = new HashMap<>();

	/**
	 * {@inheritDoc}
	 *
	 * <p>The default implementation returns the result of calling
	 * {@link #visitChildren} on {@code ctx}.</p>
	 */
	@Override
	public Object visitQuery(relationalAlgebraParser.QueryContext ctx) {
		return visitOperator(ctx.operator());
	}

	/**
	 * {@inheritDoc}
	 *
	 * <p>The default implementation returns the result of calling
	 * {@link #visitChildren} on {@code ctx}.</p>
	 */
	@Override
	public Object visitOperator(relationalAlgebraParser.OperatorContext ctx) {
		if (ctx.join() != null) {
			return visitJoin(ctx.join());
		} else if (ctx.antijoin() != null) {
			return visitAntijoin(ctx.antijoin());
		} else if (ctx.union() != null) {
			return visitUnion(ctx.union());
		} else if (ctx.rec() != null) {
			return visitRec(ctx.rec());
		} else if (ctx.relation() != null) {
			return visitRelation(ctx.relation());
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitJoin(relationalAlgebraParser.JoinContext ctx) {
		return (Object) new Join(
				(List<Operator>) visitOperatorSeq(ctx.operatorSeq()),
				(List<List<Term>>) visitVectorSeq(ctx.vectorSeq()),
				(List<Term>) visitVector(ctx.vector())
		);
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitAntijoin(relationalAlgebraParser.AntijoinContext ctx) {
		return (Object) new AntiJoin(
				(List<Operator>) visitOperatorSeq(ctx.operatorSeq()),
				(List<List<Term>>) visitVectorSeq(ctx.vectorSeq()),
				(List<Term>) visitVector(ctx.vector())
		);
	}

	@Override
	public Object visitUnion(relationalAlgebraParser.UnionContext ctx) {
		return (Object) new Union((List<Operator>) visitOperatorSeq(ctx.operatorSeq()));
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitRec(relationalAlgebraParser.RecContext ctx) {
		RecursiveOperator rec = new RecursiveOperator();
		idb.put(ctx.relationName().IDENTIFIER().toString(), rec);
		rec.setBody((Operator) visitOperator(ctx.operator()));
		return (Object) rec;
	}

	@Override
	public Object visitOperatorSeq(relationalAlgebraParser.OperatorSeqContext ctx) {
		List<Operator> operators = new ArrayList<>();
		for (relationalAlgebraParser.OperatorContext operatorContext : ctx.operator()) {
			operators.add((Operator) visitOperator(operatorContext));
		}
		return (Object) operators;
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitVectorSeq(relationalAlgebraParser.VectorSeqContext ctx) {
		List<List<Term>> vectors = new ArrayList<>();
		for (relationalAlgebraParser.VectorContext vectorContext : ctx.vector()) {
			vectors.add((List<Term>) visitVector(vectorContext));
		}
		return (Object) vectors;
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitVector(relationalAlgebraParser.VectorContext ctx) {
		List<Term> vector = new ArrayList<>();
		for (relationalAlgebraParser.TermContext termContext : ctx.term()) {
			vector.add((Term) visitTerm(termContext));
		}
		return (Object) vector;
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitRelation(relationalAlgebraParser.RelationContext ctx) {
		if (ctx.relationName() != null) {
			return visitRelationName(ctx.relationName());
		} else if (ctx.getText().contains("$")) {
			return (Object) edb.getByName(ctx.IDENTIFIER().toString());
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitRelationName(relationalAlgebraParser.RelationNameContext ctx) {
		return (Object) idb.get(ctx.IDENTIFIER().toString());
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitTerm(relationalAlgebraParser.TermContext ctx) {
		if (ctx.functionSym() != null) {
			return visitFunctionSym(ctx.functionSym());
		} else {
			return (Object) new Variable(ctx.getText());
		}
	}

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public Object visitFunctionSym(relationalAlgebraParser.FunctionSymContext ctx) {
		if (ctx.term() != null) {
			return (Object) new FunctionalSymbol(ctx.IDENTIFIER().toString(), List.of((Term) visitTerm(ctx.term())));
		} else {
			return (Object) new FunctionalSymbol(ctx.IDENTIFIER().toString());
		}
	}

	public void addRelation(String name, Operator operator) {
		this.idb.put(name, operator);
	}
}